<?php
/*电子书处理类*/
class ebook
{
public $titlelen=30, #假定小说标题不超过30个字
       $charset='gbk', #小说编码
       $fenzhangbds='!第.*章!'; #分章用的正则表达式
protected $fp; #文件指针
/*构造方法，$fn为小说文件名*/
function __construct($fn,$charset=true)
{
if($charset!==true)
  $this->charset=$charset;
$this->fp=fopen($fn,'r+');
if(!$this->fp)
  return false;
else
  return true;
}
function __distruct()
{
if($this->fp)
 fclose($this->fp);
}
/*移动文件指针*/
function move($seek,$type=SEEK_SET)
{
	return fseek($this->fp,$seek,$type);
}
/*小说分章，按顺序依次返回每一章的标题和内容，格式为array('title'=>标题,'nr'=>内容)。
参数$tt1nr的意思是“内容的第一行是否包含标题”，$nextt是内容结尾是否包含下一章节名。*/
function fenzhang($tt1nr=true,$nextt=false)
{
static $title;
if(!$title)
  $title=iconv('utf-8',$this->charset.'//IGNORE',"『扉页』\n");
if(feof($this->fp))
  return false;
$nr='';
$tit=$title;
if($tt1nr)
 $nr=$tit."\n";
while(true)
 {
if(feof($this->fp))
{$title=''; break;}
$yihang=html_entity_decode(str_replace('&amp;','&',fgets($this->fp)),ENT_QUOTES,$this->charset);
/*[0-9一二三四五六七八九十零百千]+[章卷回节段]*/
if(mb_strlen($yihang, $this-> charset) <= $this->titlelen && preg_match(iconv('utf-8',$this->charset.'//IGNORE',$this-> fenzhangbds),$yihang))
{$title=$yihang; break;}
$nr.=$yihang;
 }
if($nextt&&$title)
 $nr.=iconv('utf-8',$this->charset.'//IGNORE',"\n下一章：").$title;
else
  $nr.=' ';
return array('title'=>$tit,'nr'=>$nr);
}
function fgets()
{
if(feof($this->fp))
 return false;
else
  return html_entity_decode(str_replace('&amp;','&',fgets($this->fp)),ENT_QUOTES,$this->charset);
}
#ebook类结束#
}
?>