<?php
/*iconv/mb兼容函数*/
if(!function_exists('iconv_substr') && function_exists('mb_substr'))
{
 function iconv_strlen($data,$code=null)
 {
return mb_strlen($data,$code);
 }
function iconv_substr($data,$offset,$len=null,$code=null)
 {
return mb_substr($data,$offset,$len,$code);
 }
function iconv($oldcode,$newcode,$data)
 {
$newcode=explode('//',$newcode);
return mb_convert_encoding($data,$newcode[0],$oldcode);
 }
}
/*END*/
function _extname($path)
{
return strtolower(pathinfo($path,PATHINFO_EXTENSION));
}
function _editsave($edit,$set,&$msg)
{
$msg=null;
if($set['autobak'])
 {
$msg='保存备份';
$msg.= copy($edit['path'],$edit['path'].'.bak') ? '成功' : '失败';
$msg.='<br/>';
 }
$content=implode(null,$edit['content']);
$content=preg_replace('!€php(.*)€!ue','\\1',$content);
if($edit['code'] && strtolower($edit['code'])!=='utf-8')
 $content=iconv('utf-8',$code.'//IGNORE',$content);
$msg.='文件更新';
if(file_put_contents($edit['path'],$content)!==false) {
$msg.='成功';
$ok=true;
 }
else
 {
$msg.='失败';
$ok=false;
 }
$msg.='<br/>';
return $ok;
}
function _encode($data) {
return str_replace(array('+','/','='),array('-','_','.'),base64_encode($data));
}
function _decode($data) {
return base64_decode(str_replace(array('-','_','.'),array('+','/','='),$data));
}
function _opendir($path) {if(($handle=opendir($path))==false) {
return false;
}
while($f=readdir($handle)) {
$fp=$path.'/'.$f;
if($f=='.') {
$data['.']=$fp;
} elseif($f=='..') {
if(substr($path,-2,2)=='..')
 $data['..']=$fp;
elseif($path=='.')
 $data['..']='..';
else
 $data['..']=dirname($path);
} elseif(is_dir($fp)) {
$data['dir'][]=$fp;
} elseif(is_file($fp)) {$data['file'][]=$fp;
} else {
$data['other'][]=$fp;}
}
return $data;
}
function path2name($path) {return basename($path);
}
function _filesize($path) {
$size=filesize($path);
if($size<='1024') {
return $size.'B';
} elseif($size<=(1024*1024)) {
$size=$size/1024;
return round($size,3).'KB';
} elseif($size<=(1024*1024*1024)) {
$size=$size/1024/1024;
return round($size,3).'MB';
} else {
$size=$size/1024/1024/1024;
return round($size,3).'GB';
}
}
function _filemime($path) {
if(function_exists('finfo_open')) {
$finfo=finfo_open(FILEINFO_MIME);
$mime=finfo_file($finfo,$path);
finfo_close($finfo);
return $mime;
} elseif(function_exists('mime_content_type')) {
return mime_content_type($path);
} else {
return 'application/octet-stream';
}
}
function _mkdir($dir,$c=0777)
{
 if(is_dir($dir))
  return true;
$pdir=dirname($dir);
 if(!is_dir($pdir))
  _mkdir($pdir,$c);
 return mkdir($dir,$c);
}
function copyDir($dirName,$newdir) {
if(!is_dir($dirName)) {
if(is_file($dirName))
 return copy($dirName,$newdir);
else
 return false;
}
if(!is_dir($newdir))
 _mkdir($newdir);
$handle=opendir($dirName);
while($file=readdir($handle)) {
if($file!="."&&$file!="..") {
$dir=$dirName."/".$file;
$newpath=$newdir.'/'.$file;
is_dir($dir) ? copyDir($dir,$newpath) : copy($dir,$newpath);
}
}
closedir($handle);
return true;
}
function removeDir($dirName) {
if(!is_dir($dirName)) {
return false;
}
$handle=opendir($dirName);
while($file=readdir($handle)) {
if($file!="."&&$file!="..") {
$dir=$dirName."/".$file;
is_dir($dir) ? removeDir($dir) : unlink($dir);
}
}
closedir($handle);
return rmdir($dirName) ;
}

function removeFile($path) {
if(is_file($path)) {
unlink($path);
}
if(is_file($path)==false) {
return true;
} else {
return false;
}
}
function _view($path,$size,$code='utf-8') {
if(filesize($path)==0) {
return false;
}
if(($data=file_get_contents($path))==false) {
return false;
}
if(function_exists('iconv_substr')==true) {
if($code && strtolower($code)!=='utf-8')
 $data=iconv($code,'utf-8//IGNORE',$data);
$total_page=ceil(iconv_strlen($data,'utf-8')/$size);
for($i=0;$i<$total_page;$i++)  {
$idata[]=iconv_substr($data,$size*$i,$size,'utf-8');
}
return $idata;
}
else
 return array($data);
}
function _ReadData($path) {
return file_get_contents($path);
}
function urlupload($path,$furl) {if(function_exists('curl_init')) {
$ch=curl_init();
if(($fp=fopen($path,'w'))==false) {
return null;
}
curl_setopt($ch,CURLOPT_URL,$furl);
curl_setopt($ch,CURLOPT_FILE,$fp);
curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
curl_exec($ch);
curl_close($ch);
fclose($fp);
return true;}
else
 {
$fp=fopen($path,'w');
if(!$fp) return null;
$fp2=fopen($furl,'r');
if(!$fp2) return false;
while(!feof($fp2))
{fwrite($fp,fread($fp2,8192));}
fclose($fp2);
fclose($fp);
return true;
 }
}
function is_url ($str){
return preg_match ('!^[a-zA-Z_][a-zA-Z0-9_]*://.+$!',$str);
}
?>